/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import de.mennomax.astikorcarts.client.renderer.texture.Material;
import de.mennomax.astikorcarts.client.renderer.texture.PreparedMaterial;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.model.ModelManager;

public class AssembledTexture {
    private final int width;
    private final int height;
    private final ObjectList<Material> materials = new ObjectArrayList();

    public AssembledTexture(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public AssembledTexture add(Material material) {
        this.materials.add((Object)material);
        return this;
    }

    AbstractTexture assemble(ModelManager sprites) {
        PreparedMaterial[] prepared = new PreparedMaterial[this.materials.size()];
        int resolution = 1;
        ObjectListIterator it = this.materials.iterator();
        while (it.hasNext()) {
            PreparedMaterial p;
            int i = it.nextIndex();
            prepared[i] = p = ((Material)it.next()).prepare(sprites);
            resolution = Math.max(resolution, p.getResolution());
        }
        NativeImage image = new NativeImage(this.width * resolution, this.height * resolution, true);
        for (PreparedMaterial p : prepared) {
            p.draw(image, resolution);
        }
        return new DynamicTexture(image);
    }
}

